/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardHttpServerTransport
extends SearchGuardSSLNettyHttpServerTransport {
    private static final Logger log = LogManager.getLogger(SearchGuardHttpServerTransport.class);

    public SearchGuardHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, SslExceptionHandler sslExceptionHandler, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory) {
        super(settings, networkService, bigArrays, threadPool, sgks, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, sslExceptionHandler);
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        super.incomingRequest(this.fixNonStandardContentType(httpRequest), httpChannel);
    }

    private HttpRequest fixNonStandardContentType(final HttpRequest httpRequest) {
        try {
            BytesReference content = httpRequest.content();
            if (content == null || content.length() == 0) {
                return httpRequest;
            }
            Map headers = httpRequest.getHeaders();
            List contentTypeHeader = (List)headers.get("Content-Type");
            if (contentTypeHeader == null || contentTypeHeader.size() != 1) {
                return httpRequest;
            }
            if (RestRequest.parseContentType((List)contentTypeHeader) != null) {
                return httpRequest;
            }
            ContentType contentType = ContentType.parseHeader((String)((String)contentTypeHeader.get(0)));
            ImmutableMap modifiedHeaders = ImmutableMap.of((Map)headers, (Object)"Content-Type", Collections.singletonList(contentType.getFormat().getMediaType()), (Object)"X-SG-Original-Content-Type", (Object)contentTypeHeader);
            return new HttpRequest((Map)modifiedHeaders){
                final /* synthetic */ Map val$modifiedHeaders;
                {
                    this.val$modifiedHeaders = map;
                }

                public String uri() {
                    return httpRequest.uri();
                }

                public List<String> strictCookies() {
                    return httpRequest.strictCookies();
                }

                public HttpRequest removeHeader(String header) {
                    return httpRequest.removeHeader(header);
                }

                public HttpRequest releaseAndCopy() {
                    return httpRequest.releaseAndCopy();
                }

                public void release() {
                    httpRequest.release();
                }

                public HttpRequest.HttpVersion protocolVersion() {
                    return httpRequest.protocolVersion();
                }

                public RestRequest.Method method() {
                    return httpRequest.method();
                }

                public Exception getInboundException() {
                    return httpRequest.getInboundException();
                }

                public Map<String, List<String>> getHeaders() {
                    return this.val$modifiedHeaders;
                }

                public HttpResponse createResponse(RestStatus status, BytesReference content) {
                    return httpRequest.createResponse(status, content);
                }

                public BytesReference content() {
                    return httpRequest.content();
                }
            };
        }
        catch (Format.UnknownDocTypeException e) {
            log.debug("Unknown content type", (Throwable)e);
            return httpRequest;
        }
        catch (Exception e) {
            log.error("Error in fixNonStandardContentType(" + httpRequest + ")", (Throwable)e);
            return httpRequest;
        }
    }
}

